
#include "dvlbutton.h"

#include <linux/autoconf.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/timer.h>
#include <linux/cdev.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/kdev_t.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/types.h>

#include <asm/uaccess.h>

struct dvlbutton_dev {
    wait_queue_head_t inq;    /* read queue */
    struct semaphore sem;
    struct cdev cdev;         /* character device */
};

enum {
	TYPE_NONE = 0,
	TYPE_BUTTON,
	TYPE_BUTTON_SHORTLONG,
	TYPE_SWITCH,
};

struct dvlbutton_entry {
    char *name;
	int type;
	char c1;
	char c2;
	int gpio;
	int irq;
	int polarity;
};

struct dvlbutton_context {
	int last_change;
	struct timespec last_time;
	int is_long;
	struct timer_list timer;
	struct dvlbutton_dev *dev;
};

extern struct dvlbutton_entry global_buttons[];

void dvl_gpio_line_config_in(int line);
void dvl_gpio_line_get(int line, int *value);
void dvl_gpio_change_get(int irq, int *button, int *change);
void dvl_gpio_clear(void);

void dvl_gpio_init(void);

